<?php
require "auth.php";
require_once "../config/db.php";

$game_id = intval($_GET['game']);

/* افزودن آیتم */
if (isset($_POST['add'])) {
    $stmt = $pdo->prepare("
        INSERT INTO items (game_id, title, price, status)
        VALUES (?, ?, ?, 1)
    ");
    $stmt->execute([$game_id, $_POST['title'], $_POST['price']]);
}

/* تغییر وضعیت */
if (isset($_GET['toggle'])) {
    $stmt = $pdo->prepare("UPDATE items SET status = IF(status=1,0,1) WHERE id=?");
    $stmt->execute([$_GET['toggle']]);
}

/* لیست آیتم‌ها */
$stmt = $pdo->prepare("SELECT * FROM items WHERE game_id=?");
$stmt->execute([$game_id]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>مدیریت آیتم‌ها</h2>

<form method="post">
    <input name="title" placeholder="نام آیتم" required>
    <input name="price" placeholder="قیمت (تومان)" required>
    <button name="add">افزودن آیتم</button>
</form>

<table border="1">
<tr>
    <th>ID</th>
    <th>نام</th>
    <th>قیمت</th>
    <th>وضعیت</th>
    <th>عملیات</th>
</tr>

<?php foreach ($items as $i): ?>
<tr>
    <td><?= $i['id'] ?></td>
    <td><?= $i['title'] ?></td>
    <td><?= $i['price'] ?></td>
    <td><?= $i['status'] ? 'فعال' : 'غیرفعال' ?></td>
    <td>
        <a href="?game=<?= $game_id ?>&toggle=<?= $i['id'] ?>">تغییر وضعیت</a>
    </td>
</tr>
<?php endforeach; ?>
</table>

<a href="games.php">🔙 بازگشت به بازی‌ها</a>