<?php
require_once "../config/db.php";
require_once "../config/bot.php";

$order_id = intval($_POST['order_id']);

// گرفتن اطلاعات سفارش + کاربر
$stmt = $pdo->prepare("
    SELECT 
        o.id,
        u.telegram_id,
        g.title AS game,
        i.title AS item
    FROM orders o
    JOIN users u ON o.user_id = u.id
    JOIN items i ON o.item_id = i.id
    JOIN games g ON i.game_id = g.id
    WHERE o.id = ? AND o.status = 'paid'
");
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("Invalid Order");
}

// آپدیت وضعیت سفارش
$stmt = $pdo->prepare("
    UPDATE orders 
    SET status = 'completed', completed_at = NOW()
    WHERE id = ?
");
$stmt->execute([$order_id]);

// ارسال پیام خودکار به کاربر
sendTelegramMessage(
    $order['telegram_id'],
    "🎉 <b>سفارش شما با موفقیت تکمیل شد</b>\n\n" .
    "🧾 شماره سفارش: <b>#{$order['id']}</b>\n" .
    "🎮 بازی: <b>{$order['game']}</b>\n" .
    "📦 آیتم: <b>{$order['item']}</b>\n\n" .
    "🙏 از خرید شما متشکریم.\n" .
    "در صورت نیاز به پشتیبانی، از داخل ربات پیام دهید."
);

echo "Order Completed";