<?php

$order_id = intval(str_replace("order_", "", $data));

$stmt = $pdo->prepare("
    SELECT o.*, i.title AS item_title
    FROM orders o
    JOIN items i ON o.item_id = i.id
    JOIN users u ON o.user_id = u.id
    WHERE o.id = ? AND u.telegram_id = ?
");
$stmt->execute([$order_id, $callback['from']['id']]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    sendMessage($chat_id, "❌ سفارش یافت نشد.");
    return;
}

$statusText = [
    'pending' => '⏳ در انتظار پرداخت',
    'paid' => '💰 پرداخت شد',
    'processing' => '⚙️ در حال انجام',
    'completed' => '✅ تکمیل شد',
    'rejected' => '❌ رد شد'
][$order['status']];

$keyboard = [
    'inline_keyboard' => [
        [['text' => '🔙 بازگشت', 'callback_data' => 'my_orders']]
    ]
];

if ($order['status'] == 'pending') {
    array_unshift(
        $keyboard['inline_keyboard'],
        [['text' => '💳 پرداخت سفارش', 'callback_data' => "pay_{$order_id}"]]
    );
}

sendMessage(
    $chat_id,
    "🧾 <b>جزئیات سفارش</b>\n\n".
    "📦 آیتم: {$order['item_title']}\n".
    "🔢 تعداد: {$order['quantity']}\n".
    "💰 مبلغ: {$order['total_price']} تومان\n".
    "📌 وضعیت: {$statusText}",
    $keyboard
);