<?php

$chat_id = $message['chat']['id'];

/* آخرین سفارش پرداخت‌نشده کاربر */
$stmt = $pdo->prepare("
    SELECT o.id 
    FROM orders o
    JOIN users u ON o.user_id = u.id
    WHERE u.telegram_id = ? AND o.status = 'pending'
    ORDER BY o.id DESC LIMIT 1
");
$stmt->execute([$message['from']['id']]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    sendMessage($chat_id, "❌ سفارشی برای ثبت رسید یافت نشد.");
    return;
}

/* بروزرسانی وضعیت */
$stmt = $pdo->prepare("UPDATE orders SET status = 'paid' WHERE id = ?");
$stmt->execute([$order['id']]);

$stmt = $pdo->prepare("UPDATE payments SET status = 'receipt_sent' WHERE order_id = ?");
$stmt->execute([$order['id']]);

sendMessage(
    $chat_id,
    "✅ رسید دریافت شد.\n\n⏳ پس از بررسی توسط پشتیبانی، سفارش انجام می‌شود."
);